package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.TipoObraDao;
import com.ejie.ab04b.model.TipoObra;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TipoObraServiceImpl generated by UDA, 11-Jan-2017 12:23:08.
 * 
 * @author UDA
 */

@Service(value = "tipoObraService")
public class TipoObraServiceImpl implements TipoObraService {

	@Autowired()
	private TipoObraDao tipoObraDao;

	/**
	 * Inserts a single row in the Ab04b70s00 table.
	 * 
	 *  tipoObra
	 *            TipoObra
	 *  TipoObra
	 *
	 * @param tipoObra the tipo obra
	 * @return the tipo obra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoObra add(TipoObra tipoObra) {
		return this.tipoObraDao.add(tipoObra);
	}

	/**
	 * Updates a single row in the Ab04b70s00 table.
	 * 
	 *  tipoObra
	 *            TipoObra
	 *  TipoObra
	 *
	 * @param tipoObra the tipo obra
	 * @return the tipo obra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoObra update(TipoObra tipoObra) {
		return this.tipoObraDao.update(tipoObra);
	}

	/**
	 * Finds a single row in the Ab04b70s00 table.
	 * 
	 *  tipoObra
	 *            TipoObra
	 *  TipoObra
	 *
	 * @param tipoObra the tipo obra
	 * @return the tipo obra
	 */
	public TipoObra find(TipoObra tipoObra) {
		return (TipoObra) this.tipoObraDao.find(tipoObra);
	}

	/**
	 * Deletes a single row in the Ab04b70s00 table.
	 * 
	 *  tipoObra
	 *            TipoObra
	 *
	 * @param tipoObra the tipo obra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipoObra tipoObra) {
		this.tipoObraDao.remove(tipoObra);
	}

	/**
	 * Finds a list of rows in the Ab04b70s00 table.
	 * 
	 *  tipoObra
	 *            TipoObra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TipoObra>
	 *
	 * @param tipoObra the tipo obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<TipoObra> findAll(TipoObra tipoObra, JQGridRequestDto jqGridRequestDto) {
		return (List<TipoObra>) this.tipoObraDao.findAll(tipoObra, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab04b70s00 table using like.
	 * 
	 *  tipoObra
	 *            TipoObra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TipoObra>
	 *
	 * @param tipoObra the tipo obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TipoObra> findAllLike(TipoObra tipoObra, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<TipoObra>) this.tipoObraDao.findAllLike(tipoObra, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab04b70s00 table.
	 * 
	 *  filterTipoObra
	 *            TipoObra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterTipoObra the filter tipo obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(TipoObra filterTipoObra, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.tipoObraDao.removeMultiple(filterTipoObra, jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the Ab04b70s00 table.
	 * 
	 *  filterTipoObra
	 *            TipoObra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<TipoObra>
	 *
	 * @param filterTipoObra the filter tipo obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<TipoObra> filter(TipoObra filterTipoObra, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<TipoObra> listaTipoObra = this.tipoObraDao.findAllLike(filterTipoObra, jqGridRequestDto, false);
		Long recordNum = this.tipoObraDao
				.findAllLikeCount(filterTipoObra != null ? filterTipoObra : new TipoObra(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<TipoObra>> reorderSelection = this.tipoObraDao.reorderSelection(filterTipoObra,
					jqGridRequestDto, startsWith);
			return new JQGridResponseDto<TipoObra>(jqGridRequestDto, recordNum, listaTipoObra, reorderSelection);
		}
		return new JQGridResponseDto<TipoObra>(jqGridRequestDto, recordNum, listaTipoObra);
	}

	/**
	 * Searches rows in the Ab04b70s00 table.
	 * 
	 *  filterTipoObra
	 *            TipoObra
	 *  searchTipoObra
	 *            TipoObra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<TipoObra>>
	 *
	 * @param filterTipoObra the filter tipo obra
	 * @param searchTipoObra the search tipo obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<TipoObra>> search(TipoObra filterTipoObra, TipoObra searchTipoObra,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.tipoObraDao.search(filterTipoObra, searchTipoObra, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab04b70s00 table.
	 * 
	 *  filterTipoObra
	 *            TipoObra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterTipoObra the filter tipo obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(TipoObra filterTipoObra, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.tipoObraDao.reorderSelection(filterTipoObra, jqGridRequestDto, startsWith);
	}

}
